% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aorist.plot.R
\name{aorist.plot}
\alias{aorist.plot}
\title{Plots aorist output as a barplot.}
\usage{
aorist.plot(aorist, col = "grey", opacity = 255, lab.sp = 1,
  add = FALSE, ...)
}
\arguments{
\item{aorist}{The output from an aorist call, or any data table with a character or factor column called 'bin' and a numeric column
called aorist.}

\item{col}{Character: colour of bars. Defined formally here rather than passed via ... simply so that it can be combined with 'opacity'.}

\item{opacity}{Numeric: opacity of each line. Defaults to 80.}

\item{lab.sp}{Integer: intervals at which to place bin labels. Defaults to 1, i.e. labelling every bin.}

\item{add}{Logical: should data be added to current plot, or should axis.setup be called to start a new plot? Defaults to FALSE.}

\item{...}{Other graphical arguments to be passed to barplot.}
}
\value{
None.
}
\description{
Just a wrapper for barplot with some tweaks added, e.g. to make bars line up with data plotted by other archSeries functions.
}
\examples{
date.ranges <- data.table(Start=c(450, 450, 600), End=c(700, 800, 650), frag.count=c(3, 6, 25))
x <- aorist(date.ranges, weight=date.ranges$frag.count, 500, 1500, bin.width=50)
aorist.plot(x, col="grey60", ylab="Total probability density")
}

